varying vec2 		texcoord;

uniform sampler2D 	tex,
			bmp;

uniform vec2		fresnel,
			spec;

uniform vec4		diffuseColor;
uniform vec4		emissionColor;	// emissionColor.rgb = emission color * emissionscale

varying vec4 		curpos,pos,prev;
uniform float		vScale;

void main()
{
	vec4 color=texture2D(tex,texcoord.st)*diffuseColor;	
	vec4 bumpcolor=texture2D(bmp,texcoord.st);

	vec3 normal=bumpcolor.xyz*2.0-1.0;
	
	// color
	gl_FragData[0].xyz=color.xyz*emissionColor.xyz;
	gl_FragData[0].a=color.a;

	// pos
	vec2 vel=((curpos.xy/curpos.w)-(prev.xy/prev.w))*0.05*vScale;
	gl_FragData[1].xy = vel;
	gl_FragData[1].z = pos.z;
	gl_FragData[1].w = emissionColor.a;

	// material params
	gl_FragData[3].r=spec.x;
	gl_FragData[3].g=spec.y*bumpcolor.a;
	gl_FragData[3].b=fresnel.x;
	gl_FragData[3].a=fresnel.y*bumpcolor.a;
}
